<?php
/*
Plugin Name: Woocommerce Product Stock Manager
Plugin URI: https://codecanyon.net/item/woocommerce-product-stock-manager/21703841
Description: WooCommerce Stock Manager allows you manage stock for products and their variables from one screen.The WooCommerce Stock Manager extension gives you a new interface (found in admin menu under post) which lists your products and variations along with their stock properties.
Author: motifcreatives
Version: 3.0.2
Developed By: motifcreatives
Author URI: https://codecanyon.net/user/motifcreatives/portfolio
Support: motifdev@gmail.com
textdomain: motif_stock_manager
License: GPL-2.0+
License URI: http://www.gnu.org/licenses/gpl-2.0.txt
*/

//If not user for security purpose
if ( ! defined( 'ABSPATH' ) ) exit; 

	//Exit if woocommerce not installed
	if ( !in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

		function motif_check_for_wooenable() {
		// Deactivate the plugin
		deactivate_plugins(__FILE__);
	
		$wooCheck = __('<div class="error notice"><p>This plugin requires <a href="http://wordpress.org/extend/plugins/woocommerce/">WooCommerce</a> plugin to be installed and active!</p></div>', 'motif-woo-product-tabs');
	
		die($wooCheck);
		}
	
	add_action( 'admin_notices', 'motif_check_for_wooenable' );
}

//Motif woo price calculator main class
class MOTIF_STOCKMANAGER_MAIN_CLASS {
	
	//constructor
	public function __construct() {
		
		$this->moduling_constant();

		if(is_admin()) {

			require_once(MOTIF_STOCKMANAGER_INVOICES_DIR.'motif-woocomemrce-stock-manager-admin.php');

		} else {

			require_once(MOTIF_STOCKMANAGER_INVOICES_DIR.'motif-woocomemrce-stock-manager-front.php');
		}

		add_action('wp_loaded', array($this, 'motif_support_motif_settings_scripts'));

		add_action( 'wp_loaded', array( $this, 'motif_scripts_styles_enqueue' ));

		// title edit update ajax callback
		add_action( 'wp_ajax_motif_product_title_save', array($this,'motif_stock_manager_product_title_save' )); 
		// sku edit update ajax callback
    	add_action( 'wp_ajax_motif_sku_saving', array($this,'motif_stock_manager_sku_save' )); 
    	// saving per row line
    	add_action( 'wp_ajax_motif_save_one_product', array($this,'motif_stock_manager_single_product_stock_data' )); 
		// sorting products ajax callback
		add_action( 'wp_ajax_motif_stocksort_action', array($this,'motif_stock_manager_sorting_callback' )); 

		// saving setting options sm
		add_action( 'wp_ajax_m_smsetting_motif_action', array($this,'motif_setting_saveingsm_callback' ));
		add_action( 'wp_ajax_nopriv_m_smsetting_motif_action', array($this,'motif_setting_saveingsm_callback' ));

		// contact us callback
		add_action( 'wp_ajax_support_motif_contact', array($this,'support_motif_callback' ));
		add_action( 'wp_ajax_nopriv_support_motif_contact', array($this,'support_motif_callback' ));

		add_action('wp_ajax_motif_product_variation_save', array($this, 'motif_product_variation_callback'));

	}

	public function motif_product_variation_callback() {

		if( current_user_can('manage_woocommerce') ) {

			$itemId = $_POST['item'];

			$setting_data = array();
        	parse_str($_POST['formData'], $setting_data);

        	for ($i=0; $i < count($setting_data['mo_variation']); $i++) { 
        	 	foreach ($setting_data as $key => $value) {
        	 		// for sku
	 				update_post_meta( $value[$i]['variation_id'], '_sku', $value[$i]['variation_sku'] );

	 				// for sale price
	 				update_post_meta( $value[$i]['variation_id'], '_sale_price', $value[$i]['variation_sale_price'] );

	 				// for regular price
	 				update_post_meta( $value[$i]['variation_id'], '_regular_price', $value[$i]['variation_regular_price'] );

	 				// for manage stock
	 				update_post_meta( $value[$i]['variation_id'], '_manage_stock', $value[$i]['variation_stock_manage'] );

	 				// for stock status
	 				update_post_meta( $value[$i]['variation_id'], '_stock_status', $value[$i]['variation_stock_status'] );

	 				// for stock
	 				update_post_meta( $value[$i]['variation_id'], '_stock', $value[$i]['variation_stock'] );
	 			}		
        	} 
       
		} die();	
	}

	// saving one line data stock
	public function motif_stock_manager_single_product_stock_data(){
	
	    if( current_user_can('manage_woocommerce') ){

	        $mo_product_id = sanitize_text_field( $_POST['product'] );
	        $motif_product = wc_get_product( $mo_product_id );

        	if( isset( $_POST['manage_stock'] ) ) {
			    $mo_manage_stock = sanitize_text_field( $_POST['manage_stock'] );
			    $motif_product->set_manage_stock( $mo_manage_stock );
			}
			
			if( isset( $_POST['stock_status'] ) ) {
			    $mo_stock_status = sanitize_text_field( $_POST['stock_status'] );
			    $motif_product->set_stock_status( $mo_stock_status );
			}

			if( isset( $_POST['stock'] ) ) {
	            $mo_stock = sanitize_text_field( $_POST['stock'] );       
	            $motif_product->set_stock_quantity( $mo_stock );
	        }

	        if( isset( $_POST['regular_price'] ) ) {
	            $mo_regular_price = sanitize_text_field( $_POST['regular_price'] );       
	            $motif_product->set_regular_price( $mo_regular_price );
	        }

	        if( isset( $_POST['sales_price'] ) ) {
	            $mo_sales_price = sanitize_text_field( $_POST['sales_price'] );       
	            $motif_product->set_sale_price( $mo_sales_price );
	        }

	        if( isset( $_POST['weight'] ) ){
	          $mo_weight = sanitize_text_field( $_POST['weight'] );
	          $motif_product->set_weight( $mo_weight );
	        }

	        $motif_product->save();

	        wc_delete_product_transients($mo_product_id);
	     
	    } exit();
	}  


	// setting options predefiend data
	public function motif_support_motif_settings_scripts() {

    	$per_page_product = get_option('motif_sm_per_product');	
	 	if($per_page_product !='') {
	 		$per_page_product = get_option('motif_sm_per_product');	
	 	}else {
	 		$per_page_product = 10; 
	 	}

	 	$ins = get_option('motif_instock_color');	
	 	if($ins !='') {
	 		$ins = get_option('motif_instock_color');	
	 	}else {
	 		$ins = "#00FF00"; 
	 	}

	 	$lows = get_option('motif_lowstock_color');	
	 	if($lows !='') {
	 		$lows = get_option('motif_lowstock_color');	
	 	}else {
	 		$lows = "#ffa500"; 
	 	}

	 	$outs = get_option('motif_outstock_color');	
	 	if($outs !='') {
	 		$outs = get_option('motif_outstock_color');	
	 	}else {
	 		$outs = "#FF0000"; 
	 	}

		$sm_settings = array();

 		$sm_settings['per_page_product'] = $per_page_product;  
 		$sm_settings['ins'] = $ins;  
 		$sm_settings['lows'] = $lows;  
 		$sm_settings['outs'] = $outs;  

 		return $sm_settings;
    }

	public function motif_stock_manager_sku_save(){
	   
	    if( current_user_can('manage_woocommerce') ){
	        $motif_item   = sanitize_text_field($_POST['item']);
	        $motif_sku   = sanitize_text_field($_POST['sku']);
	        
	        update_post_meta( $motif_item, '_sku', $motif_sku );
	    }
	    echo $motif_item;
	    exit();
	} 

  	// ajax callback for product name
  	public function motif_stock_manager_product_title_save(){
    
	    if( current_user_can('manage_woocommerce') ){
	        $motif_item   = sanitize_text_field($_POST['item']);
	        $motif_title   = sanitize_text_field($_POST['title']);
	        $args = array(
	            'ID'           => $motif_item,
	            'post_title'   => $motif_title,
	        );
	        $product_id = wp_update_post( $args );
	    }
	    echo $product_id;
	    exit($product_id);
    
	} 

	// ----------------------------------------------------- //
	// --------------fILTERS ALL------------------------------//
	// -------------------------------------------------------//

	public function motif_stock_manager_sorting_callback() {

		if(isset($_POST['condition']) && $_POST['condition'] == "motif_stocksort_condition") {
			
			$filters = $_POST['id'];
			
			$filters_value = explode(":",$filters);

			$args = array(
			  'posts_per_page' => -1,
			  'post_type'   => 'product',
			  'order'=> $filters_value[1],
			  'orderby' => $filters_value[0]
			); 

			$products = get_posts( $args );

			$sr_number = 1;
			
			foreach ($products as $product) { 

				$product = wc_get_product( $product->ID );

				$setings = $this->motif_support_motif_settings_scripts();

				?>
				    <tr >
				      	<td class="mo_proid">
				      		<?php echo $product->get_id(); ?>		
				      	</td>
				      	<td class="mo_protype">
				      		<?php if ($product->get_type() == "variable") : 
		      					$available_variations = $product->get_available_variations(); ?>
		      				<?php esc_html_e('Variable'.' ('.count($available_variations).')', ''); ?>		
		      					<span class="dashicons dashicons-edit" data-item="<?php echo $product->get_id(); ?>"></span>
				      			<div class="item-type-wrap item-type-wrap-<?php echo $product->get_id(); ?>">
				      				<form id="product-varition<?php echo $product->get_id(); ?>">
				      				<table>
				      					<thead>
				      						<tr>
				      							<td>Product ID</td>
				      							<td>Product Name</td>
				      							<td>Product Variation</td>
				      							<td>Stock</td>
				      							<td>Manage Stock</td>
				      							<td>Stock Status</td>
				      							<td>Sku</td>
				      							<td>Sale Price</td>
				      							<td>Regular Price</td>
				      						</tr>
				      					</thead>
				      					<tbody>
					      					<?php $i= 0; foreach ($available_variations as $key => $value) { 
					      						$variation = wc_get_product($value['variation_id']); ?>
				      							<tr value="<?php echo $value['variation_id']; ?>">
						      						<td>
						      							<?php echo $value['variation_id']; ?>
						      							<input type="hidden" name="mo_variation[<?php echo $i; ?>][variation_id]" value="<?php echo $value['variation_id']; ?>">
						      						</td>
						      						<td>
						      							<?php $product = wc_get_product( $variation->get_parent_id() ); 
						      								 echo $product->get_title();
						      							?>
						      						</td>
						      						<td>
						      							<?php echo $variationName = implode(",", $variation->get_variation_attributes()); ?>
						      						</td>
						      						<td>
						      							<input type="text" name="mo_variation[<?php echo $i; ?>][variation_stock]" value="<?php echo $variation->get_stock_quantity(); ?>">
						      						</td>
						      						<td>
						      							<select name="mo_variation[<?php echo $i; ?>][variation_stock_manage]" class="m_managev_stock_<?php echo $product->get_id(); ?>">
												      		<?php if($variation->get_manage_stock() == "yes") { ?>
												      			<option selected="selected" value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
												              	<option value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
												      		<?php } else if($variation->get_manage_stock() == "no") { ?>
												      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
												              	<option value="no" selected="selected"><?php echo _e('No', 'motif_stock_manager'); ?></option>
												      		<?php } else { ?>
												      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
												              	<option selected="selected" value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
												      		<?php } ?>
											            </select>
						      						</td>
						      						<td>
						      							<select name="mo_variation[<?php echo $i; ?>][variation_stock_status]" class="m_stockv_status_<?php echo $product->get_id(); ?>">
												      		<?php if($variation->get_stock_status() == "instock") { ?>
												      			<option selected="selected" value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
												      			<option value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
												      			<?php  } else if($variation->get_stock_status() == "outofstock") { ?>
												      			<option value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
												      			<option selected="selected" value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
												      		<?php } ?>
											      		</select>
						      						</td>
						      						<td>
						      							<input type="text" name="mo_variation[<?php echo $i; ?>][variation_sku]" value="<?php echo $variation->get_sku(); ?>">
						      						</td>
						      						<td>
						      							<input type="text" name="mo_variation[<?php echo $i; ?>][variation_regular_price]" value="<?php echo $variation->get_regular_price(); ?>">
						      						</td>
						      						<td>
						      							<input  type="text" name="mo_variation[<?php echo $i; ?>][variation_sale_price]" value="<?php echo $variation->get_sale_price(); ?>">
						      						</td>
						      					</tr>
					      					<?php $i++; } ?>
				      					</tbody>
				      				</table>
				                    <span class="btn btn-primary btn-xs item-post-tpe-button" data-item="<?php echo $product->get_id(); ?>">Save</span>
				                    <span class="btn btn-danger btn-xs item-type-wrap-button-close">Close</span>
				                    </form>
				                </div>
				      		<?php else: ?>
				      			<?php esc_html_e('Simple', ''); ?>
				      		<?php endif; ?>		
				      	</td>
				      	<td class="mo_proimage">
				      		<img class="mtf-img" src="<?php echo get_the_post_thumbnail_url( $product->get_id()); ?>"></td>
				      	<td class="mo_prosku">
				      		<span class="item-sku-text-<?php echo $product->get_id(); ?>"><?php echo $product->get_sku(); ?></span>
				      		<span class="dashicons dashicons-edit" data-item="<?php echo $product->get_id(); ?>"></span>
				      		<div class="item-sku-wrap item-sku-wrap-<?php echo $product->get_id(); ?>">
			                    <input type="text" name="sku[<?php echo $product->get_id(); ?>]" class="item-sku sku_<?php echo $product->get_id(); ?>" value="<?php echo $product->get_sku(); ?>">
			                    <span class="btn btn-primary btn-xs item-sku-button" data-item="<?php echo $product->get_id(); ?>">Save</span>
			                    <span class="btn btn-danger btn-xs item-sku-button-close">Close</span>
			                </div>
				      	</td>
				      	<td class="mo_proname">
				      		<a target="_blank"  href="<?php echo admin_url('/post.php?post='.$product->get_id().'&action=edit'); ?>" class="item-post-link-<?php echo $product->get_id(); ?>">
				      			<?php echo $product->get_name(); ?>	
				      		</a>
				      		<span class="dashicons dashicons-edit" data-item="<?php echo $product->get_id(); ?>"></span>
				      		<div class="item-post-title-wrap item-post-title-wrap-<?php echo $product->get_id(); ?>">
			                    <input type="text" name="item-post-title" class="item-post-title item-post-title-<?php echo $product->get_id(); ?>" value="<?php echo $product->get_name(); ?>">
			                    <span class="btn btn-primary btn-xs item-post-title-button" data-item="<?php echo $product->get_id(); ?>">Save</span>
			                    <span class="btn btn-danger btn-xs item-post-title-button-close">Close</span>
			                </div>
				      	</td>
				      	<td class="mo_prorprice">
				      		<input class="m_number_f m_regular_price_<?php echo $product->get_id(); ?>" type="number" min="0.01" step="0.01" name="m_regular_price" value="<?php echo $product->get_regular_price(); ?>">
				      	</td>
				      	<td class="mo_prosprice">
				      		<input class="m_number_f m_sales_price_<?php echo $product->get_id(); ?>" type="number" min="0.01" step="0.01" name="m_sale_price" value="<?php echo $product->get_sale_price(); ?>">
				      	</td>
				      	<td class="mo_proweight">
				      		<input class="m_number_f weight_<?php echo $product->get_id(); ?> wc_input_decimal" name="m_weight" value="<?php echo $product->get_weight(); ?>">
				      	</td>
				      	<td class="mo_promngstock">
				      		<select class="m_manage_stock_<?php echo $product->get_id(); ?>">
				      		<?php if($product->get_manage_stock() == "yes") { ?>
				      			<option selected="selected" value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
				              	<option value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
				      		<?php } else if($product->get_manage_stock() == "no") { ?>
				      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
				              	<option value="no" selected="selected"><?php echo _e('No', 'motif_stock_manager'); ?></option>
				      		<?php } else { ?>
				      			<option value="yes"><?php echo _e('Yes', 'motif_stock_manager'); ?></option>
				              	<option selected="selected" value="no"><?php echo _e('No', 'motif_stock_manager'); ?></option>
				      		<?php } ?>
				            </select>
				      	</td>
				      	<td class="mo_stockstatus">
				      		<select class="m_stock_status_<?php echo $product->get_id(); ?>">
				      		<?php if($product->get_stock_status() == "instock") { ?>
				      			<option selected="selected" value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
				      			<option value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
				      			<?php  } else if($product->get_stock_status() == "outofstock") { ?>
				      			<option value="instock"><?php echo _e('In Stock', 'motif_stock_manager'); ?></option>
				      			<option selected="selected" value="outofstock"><?php echo _e('Out Of Stock', 'motif_stock_manager'); ?></option>
				      		<?php } ?>
				      		</select>
				      	</td>
				    	<td class="mo_proquantity" style="background-color: <?php if($product->get_stock_quantity() == '0' || $product->get_stock_quantity() == '') echo $setings['outs']; else if ($product->get_stock_quantity() <='5') echo $setings['lows']; else if ( $product->get_stock_quantity() >='6' ) echo $setings['ins'];  else echo ""; ?>;">
				    		<input class="m_number_f m_stock_<?php echo $product->get_id(); ?>" type="number" name="m_sale_price" value="<?php echo $product->get_stock_quantity(); ?>">
				    	</td>
				    	<td>
				    		<input type="button" class="btn btn-primary btn-xs save-line-product" data-product="<?php echo $product->get_id(); ?>" value="Save">
				    		<input type="hidden" name="msm-ajax-nonce-<?php echo $product->get_id(); ?>" class="msm-ajax-nonce_<?php echo $product->get_id(); ?>" value="<?php echo wp_create_nonce( 'msm-ajax-nonce-'.$product->get_id() ); ?>" />
				    	</td>
				    </tr>

			<?php $sr_number++; } ?>

				<script type="text/javascript">
					
					jQuery('.save-line-product').on('click', function(){
				       	jQuery('.m_lineloader').css('display','block');
				       	var product = jQuery(this).data('product');
				       
				       	var regular_price  = jQuery('.m_regular_price_' + product).val();
				       	var sales_price    = jQuery('.m_sales_price_' + product).val();
				       	var weight         = jQuery('.weight_' + product).val();
				       	var manage_stock   = jQuery('.m_manage_stock_' + product).val();
				       	var stock_status   = jQuery('.m_stock_status_' + product).val();
				       	var stock          = jQuery('.m_stock_' + product).val();
				       	var secure         = jQuery('.msm-ajax-nonce_' + product).val();

				       	var data = {
				        	action         : 'motif_save_one_product',
				            product        : product,
				            manage_stock   : manage_stock,
				            stock_status   : stock_status,
				            stock          : stock,
				            regular_price  : regular_price,
				            sales_price    : sales_price,
				            weight 		   : weight,
				            secure         : secure
				       	};

				        jQuery.post(ajaxurl, data, function(response){
				          	jQuery('.m_lineloader').css('display','none'); 
				        
				        });
				       
				    });	

					//Open box for product type variation saving
					jQuery('.mo_protype .dashicons').on('click', function(){      
				        var item = jQuery(this).data('item');
				        jQuery('.item-type-wrap-'+item).css('display','block');
				    });

				    jQuery('.item-type-wrap-button-close').on('click', function(){
				        jQuery(this).parent().parent().css('display', 'none');
				    });

				    jQuery('.item-post-tpe-button').on('click', function(ajax_object){
				    	var item = jQuery(this).data('item');
				    	var formData = jQuery("#product-varition"+item).serialize();
				        var data = {
				            action  : 'motif_product_variation_save',
				            item    : item,
				            formData   : formData,
				            secure  : ajax_object.ajax_nonce
				        };
				        jQuery.post(ajaxurl, data, function(response){   
				            location.reload();
				        });
				    });

					//Open box for product title saving
			        jQuery('.mo_proname .dashicons').on('click', function(){      
			            var item = jQuery(this).data('item');
			            jQuery('.item-post-title-wrap-'+item).css('display','block');
			        });

			        jQuery('.item-post-title-button-close').on('click', function(){
			            jQuery(this).parent().css('display', 'none');
			        });

			        //Save product title
			        jQuery('.item-post-title-button').on('click', function(ajax_object){
			           
			            var item = jQuery(this).data('item');
			            var title = jQuery('.item-post-title-'+item).val();
			            var data = {
			                action  : 'motif_product_title_save',
			                item    : item,
			                title   : title,
			                secure  : ajax_object.ajax_nonce
			            };
			            jQuery('.item-post-title-'+item).val(title); 
			            jQuery('.item-post-link-'+item).text(title);  
			            
			            jQuery.post(ajaxurl, data, function(response, item, title){   
			                jQuery('.item-post-title-wrap-'+response).css('display', 'none');
			            });
			            
			        });


			        //Open box for sku saving
			        jQuery('.mo_prosku .dashicons').on('click', function(){      
			            var item = jQuery(this).data('item');
			            jQuery('.item-sku-wrap-'+item).css('display','block');
			        });
			        //Close box for sku saving
			        jQuery('.item-sku-button-close').on('click', function(){
			            jQuery(this).parent().css('display', 'none');
			        });
			        // //Save sku
			        jQuery('.item-sku-button').on('click', function(ajax_object){
			           
			            var item = jQuery(this).data('item');
			            var sku = jQuery('.sku_'+item).val();
			            var data = {
			                action  : 'motif_sku_saving',
			                item    : item,
			                sku     : sku,
			                secure  : ajax_object.ajax_nonce
			            };
			            jQuery('.sku_-'+item).val(sku); 
			            jQuery('.item-sku-text-'+item).text(sku);  
			            
			            jQuery.post(ajaxurl, data, function(response, item, sku){   
			                jQuery('.item-sku-wrap-'+response).css('display', 'none');      
			            });
			            
			        });

					// pagination
					jQuery(function() {
					    jQuery("div.holder").jPages({
					      containerID: "msm_mbody",
					      previous : "«",
					      next : "»",
					      perPage: <?php echo $setings['per_page_product']; ?>,
					      minHeight : false,
					      animation : "",
					    });
					});
				</script>

			<?php } die();

	}

	// ----------------------------------------------------- //
	// -------setting options ajax function ALL--------------//
	// -------------------------------------------------------//

	// Motif setting saving
	public function motif_setting_saveingsm_callback() {

		if(isset($_POST['condition']) && $_POST['condition'] == "m_smsetting_motif") {

			update_option( 'motif_sm_per_product', sanitize_text_field($_POST['pro_per_row']), null);
			update_option( 'motif_instock_color', sanitize_text_field($_POST['instockcolor']), null);
			update_option( 'motif_lowstock_color', sanitize_text_field($_POST['lowstockcolor']), null);
			update_option( 'motif_outstock_color', sanitize_text_field($_POST['outstockcolor']), null);


		} die();
	}

	// motif support callback email function
    public function support_motif_callback () {
		
		if(isset($_POST['condition']) && $_POST['condition'] == "motif_support_contact") {

			$suppextemail = sanitize_email($_POST['motif_useremail']);
			$support_subject = sanitize_text_field($_POST['motif_subject']);
			$support_message = sanitize_text_field($_POST['motif_message']);
			$suppextfname = sanitize_text_field($_POST['motif_username']);
		
			$to = "Motifdev@gmail.com";
			$subject = $support_subject;
			
			$admin_emailsup = get_option('admin_email');

			$message = "
			<html>
			<head>
			<title>Motif Support Email (Motif Sotck Manger)</title>
			</head>
			<body>
			<p>This email contains HTML Tags!</p>
			<table>
			<tr>
			<th>User Information</th>
			<th>Message</th>
			</tr>
			<tr>
			<td>Dear Motif Admin a user name with $suppextfname and email with ($suppextemail)</td>
			<td>Have some query regarding Woocommerce Stock Manager Codecanyoun, Message is $support_message</td>
			</tr>
			</table>
			</body>
			</html>
			";

			// Always set content-type when sending HTML email
			$headers = "MIME-Version: 1.0" . "\r\n";
			$headers .= "Content-type: text/html; charset=iso-8859-1\n";

			// More headers
			$headers .= 'From: <'.$admin_emailsup.'>' . "\r\n";

			mail($to,$subject,$message,$headers);

		}

		die();
	}

	//Motif module constant 
	public function moduling_constant() {

		if ( !defined( 'MOTIF_STOCKMANAGER_INVOICES_URL' ) )
	    define( 'MOTIF_STOCKMANAGER_INVOICES_URL', plugin_dir_url( __FILE__ ) );

	    if ( !defined( 'MOTIF_STOCKMANAGER_INVOICES_BASENAME' ) )
	    define( 'MOTIF_STOCKMANAGER_INVOICES_BASENAME', plugin_basename( __FILE__ ) );

	    if ( ! defined( 'MOTIF_STOCKMANAGER_INVOICES_DIR' ) )
	    define( 'MOTIF_STOCKMANAGER_INVOICES_DIR', plugin_dir_path( __FILE__ ) );
	}

	//Motif scripts and style main
	public function motif_scripts_styles_enqueue() { 

		wp_enqueue_script('jquery');

		wp_enqueue_script('jquery-ui-tabs');
		
		wp_enqueue_style( 'motif-bootstrap-css', plugins_url( '/css/bootstrap-iso.css', __FILE__ ), false );

		wp_enqueue_script( 'motif-bootstrap-js', plugins_url( '/scripts/bootstrap.min.js', __FILE__ ), false);

		wp_enqueue_style( 'motif-backend-css', plugins_url( '/css/backend-style.css', __FILE__ ), false);
		
		if ( function_exists( 'load_plugin_textdomain' ) )
				load_plugin_textdomain( 'motif_stock_manager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );	
	} 	

} new MOTIF_STOCKMANAGER_MAIN_CLASS();

add_action( 'before_woocommerce_init', function() {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}